const int touchPin = 4;
const int ledPin = 5;

const int threshold = 20;
int touchValue;

unsigned long reftimePrint = millis();
unsigned long intervalPrint = 500;

void setup() {
  Serial.begin(115200);
  pinMode(ledPin, OUTPUT);
}

void loop() {
  touchValue = touchRead(touchPin);

  if (touchValue < threshold) {
    digitalWrite(ledPin, HIGH);
  } else {
    digitalWrite(ledPin, LOW);
  }

  if (millis() - reftimePrint >= intervalPrint) {
    Serial.print(touchValue);
    
    if (touchValue < threshold) {
      Serial.println(" - LED on");
    } else {
      Serial.println(" - LED off");
    }
    
    reftimePrint = millis();
  }
}