#ifdef ESP8266
#include <ESP8266WiFi.h>
#else
#include <WiFi.h>
#endif
#include "time.h"

char ssid[] = ".......................";        // Network SSID (name)
char pass[] = "..........";                     // Network password

const char* ntpServer = "pool.ntp.org";
const long  gmtOffset_sec = -3*3600;
const int   daylightOffset_sec = 0;

void setup() {

  Serial.begin(115200);

  Serial.println("Start (10 s)");

  delay(10000);

  // Connect to WiFi network
  Serial.println();
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, pass);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");

  Serial.println("WiFi connected");
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

}

void loop() {

  printTime();
  delay(5000);

}

void printTime() {

  configTime(gmtOffset_sec, daylightOffset_sec, ntpServer);
  struct tm timeinfo;
  if(!getLocalTime(&timeinfo)){
    Serial.println("Failed to obtain time");
    return;
  }

  Serial.println();
  Serial.print("Mes: ");    // 0-11
  Serial.println(timeinfo.tm_mon);
  Serial.print("Día: ");    // 1-31
  Serial.println(timeinfo.tm_mday);
  Serial.print("Año: ");
  Serial.println(timeinfo.tm_year+1900); // desde 1900
  Serial.print("Hora: ");
  Serial.println(timeinfo.tm_hour);   // 0-23
  Serial.print("Minuto: ");
  Serial.println(timeinfo.tm_min);    // 0-59
  Serial.print("Segundo: ");
  Serial.println(timeinfo.tm_sec);    // 0-59
  
}
