/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerView;
import controlP5.Label;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;

public class Tooltip {
    private ControllerView<?> _myView;
    private PVector position = new PVector();
    private PVector currentPosition = new PVector();
    private PVector previousPosition = new PVector();
    private PVector offset = new PVector();
    private Controller<?> _myController;
    private long startTime = 0L;
    private long _myDelayInMillis = 500L;
    private int _myMode = 0;
    private int _myHeight = 20;
    private int _myBackgroundColor = -76;
    private int _myMaxAlpha = 255;
    private int _myAlpha = 0;
    private Map<Controller<?>, String> map;
    private Label _myLabel;
    private boolean enabled = true;
    private int _myBorder;
    private ControlP5 cp5;
    private int _myAlignH = 39;
    private int _myColor = 0;

    Tooltip(ControlP5 controlP5) {
        this.cp5 = controlP5;
        this.position = new PVector(-1000.0f, -1000.0f);
        this.currentPosition = new PVector();
        this.previousPosition = new PVector();
        this.offset = new PVector(0.0f, 24.0f, 0.0f);
        this.map = new HashMap();
        this._myLabel = new Label(this.cp5, "tooltip");
        this._myLabel.setColor(this._myColor);
        this._myLabel.setPadding(0, 0);
        this.setView(new TooltipView());
        this.setBorder(4);
    }

    public Tooltip setBorder(int n) {
        this._myBorder = n;
        this._myLabel.getStyle().setMargin(this._myBorder, this._myBorder, this._myBorder, this._myBorder);
        return this;
    }

    public int getBorder() {
        return this._myBorder;
    }

    public Tooltip setAlpha(int n) {
        this._myMaxAlpha = n;
        return this;
    }

    private void updateText(String string) {
        int n = 1;
        for (char c : string.toCharArray()) {
            if (c != '\n') continue;
            ++n;
        }
        if (this._myLabel.getHeight() != this._myLabel.getLineHeight() * n) {
            this._myLabel.setHeight(this._myLabel.getLineHeight() * n);
        }
        this._myLabel.set(string);
    }

    void draw(ControlWindow controlWindow) {
    }

    private boolean moved() {
        return PApplet.abs((float)PApplet.dist((float)this.previousPosition.x, (float)this.previousPosition.y, (float)this.currentPosition.x, (float)this.currentPosition.y)) > 1.0f;
    }

    public Tooltip setDelay(long l) {
        this._myDelayInMillis = l;
        return this;
    }

    protected void activate(Controller<?> controller) {
        if (this.map.containsKey(controller)) {
            this.startTime = System.nanoTime();
            this._myController = controller;
            this.currentPosition.set((float)controller.getControlWindow().mouseX, (float)controller.getControlWindow().mouseY, 0.0f);
            this.updateText(this.map.get(this._myController));
            this._myMode = 1;
        }
    }

    protected void deactivate() {
        this.deactivate(1);
    }

    protected void deactivate(int n) {
        if (n == 0) {
            if (this._myMode >= 4) {
                if (this._myMode < 5) {
                    this.startTime = System.nanoTime();
                }
                this._myMode = 5;
            }
        } else {
            this._myMode = this._myMode >= 4 ? 5 : 6;
        }
    }

    public Tooltip setView(ControllerView<?> controllerView) {
        this._myView = controllerView;
        return this;
    }

    public Tooltip register(Controller<?> controller, String string) {
        this.map.put(controller, string);
        controller.registerProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip register(String string, String string2) {
        Controller<?> controller = this.cp5.getController(string);
        if (controller == null) {
            return this;
        }
        this.map.put(controller, string2);
        controller.registerProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip unregister(Controller<?> controller) {
        this.map.remove(controller);
        controller.removeProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip unregister(String string) {
        Controller<?> controller = this.cp5.getController(string);
        if (controller == null) {
            return this;
        }
        return this.unregister(controller);
    }

    public Tooltip setWidth(int n) {
        return this;
    }

    public int getWidth() {
        return this._myLabel.getWidth();
    }

    public Tooltip setHeight(int n) {
        ControlP5.logger().warning("Tooltip.setHeight is disabled with this version");
        this._myHeight = n;
        return this;
    }

    public Tooltip setPositionOffset(float f, float f2) {
        this.offset.x = f;
        this.offset.y = f2;
        return this;
    }

    public Tooltip disable() {
        this.enabled = false;
        return this;
    }

    public Tooltip enable() {
        this.enabled = true;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Tooltip setLabel(Label label) {
        this._myLabel = label;
        return this;
    }

    public Label getLabel() {
        return this._myLabel;
    }

    public Tooltip setColorBackground(int n) {
        this._myBackgroundColor = n;
        return this;
    }

    public Tooltip setColorLabel(int n) {
        this._myColor = n;
        this._myLabel.setColor(n);
        return this;
    }

    class TooltipView
    implements ControllerView<Controller<?>> {
        TooltipView() {
        }

        @Override
        public void display(PGraphics pGraphics, Controller<?> controller) {
            Tooltip.this._myHeight = Tooltip.this._myLabel.getHeight();
            pGraphics.fill(Tooltip.this._myBackgroundColor, (float)Tooltip.this._myAlpha);
            pGraphics.rect(0.0f, 0.0f, (float)(Tooltip.this.getWidth() + Tooltip.this._myBorder * 2), (float)(Tooltip.this._myHeight + Tooltip.this._myBorder * 2));
            pGraphics.pushMatrix();
            if (Tooltip.this._myAlignH == 39) {
                pGraphics.translate(6.0f, 0.0f);
            } else {
                pGraphics.translate((float)(Tooltip.this.getWidth() - 6), 0.0f);
            }
            pGraphics.triangle(0.0f, 0.0f, 4.0f, -4.0f, 8.0f, 0.0f);
            pGraphics.popMatrix();
            int n = (int)PApplet.map((float)Tooltip.this._myAlpha, (float)0.0f, (float)Tooltip.this._myMaxAlpha, (float)0.0f, (float)255.0f);
            Tooltip.this._myLabel.setColor(n << 24 | Tooltip.this._myColor >> 16 << 16 | Tooltip.this._myColor >> 8 << 8 | Tooltip.this._myColor >> 0 << 0);
            Tooltip.this._myLabel.draw(pGraphics, 0, 0, controller);
        }
    }
}

