#if defined(ESP8266)
#include <ESP8266WiFi.h>
#else
#include <WiFi.h>
#endif
#include <WiFiUdp.h>
#include <OSCMessage.h>

char ssid[] = ".......................";        // Network SSID (name)
char pass[] = "..........";                     // Network password

WiFiUDP Udp;                                    // A UDP instance to let us send and receive packets over UDP
const IPAddress outIp(192,168,0,255);           // remote IP of your computer
const unsigned int outPort = 12000;             // remote port to receive OSC
const unsigned int localPort = 8888;            // local port to listen for OSC packets (actually not used for sending)

int n = 0;

void setup() {
  
    Serial.begin(115200);

    delay(10000);

    // Connect to WiFi network
    Serial.println();
    Serial.println();
    Serial.print("Connecting to ");
    Serial.println(ssid);
    WiFi.begin(ssid, pass);

    while (WiFi.status() != WL_CONNECTED) {
        delay(500);
        Serial.print(".");
    }
    Serial.println("");

    Serial.println("WiFi connected");
    Serial.print("IP address: ");
    Serial.println(WiFi.localIP());

    Serial.println("Starting UDP");
    Udp.begin(localPort);
    Serial.print("Local port: ");
    
#ifdef ESP32
    Serial.println(localPort);
#else
    Serial.println(Udp.localPort());
#endif

    Serial.print("Remote IP: ");
    Serial.println(outIp);
    Serial.print("Remote port: ");
    Serial.println(outPort);

}

void loop() {
  
    OSCMessage msg("/test");
    msg.add(n);
    Udp.beginPacket(outIp, outPort);
    msg.send(Udp);
    Udp.endPacket();
    msg.empty();
    
    Serial.println(n);
    
    n++;
    delay(1000);
    
}
