#ifdef ESP8266
#include <ESP8266WiFi.h>
#else
#include <WiFi.h>
#endif
#include <WiFiUdp.h>
#include <OSCMessage.h>
#include <OSCBundle.h>
#include <OSCData.h>

char ssid[] = ".......................";        // Network SSID (name)
char pass[] = "..........";                     // Network password

WiFiUDP Udp;                                    // A UDP instance to let us send and receive packets over UDP
const IPAddress outIp(192, 168, 0, 255);        // remote IP (not needed for receive)
const unsigned int outPort = 8888;              // remote port (not needed for receive)
const unsigned int localPort = 12000;           // local port to listen for UDP packets (here's where we send the packets)

IPAddress ip(192, 168, 0, 112);  //ip de la ESP
IPAddress gateway(192, 168, 0, 1);
IPAddress subnet(255, 255, 255, 0);

OSCErrorCode error;

int value;

void setup() {

  Serial.begin(115200);

  delay(10000);

  // Connect to WiFi network
  Serial.println();
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);

  WiFi.mode(WIFI_STA);
  WiFi.config(ip, gateway, subnet);

  WiFi.begin(ssid, pass);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");

  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

  Serial.println("Starting UDP");
  Udp.begin(localPort);
  Serial.print("Local port: ");

#ifdef ESP32
  Serial.println(localPort);
#else
  Serial.println(Udp.localPort());
#endif

  Serial.println("");

}

void showmsg(OSCMessage &msg) {

  value = msg.getInt(0);
  Serial.print("Received value: ");
  Serial.println(value);

}

void loop() {

  OSCMessage msg;
  int size = Udp.parsePacket();

  if (size > 0) {

    while (size--) {
      msg.fill(Udp.read());
    }

    if (!msg.hasError()) {
      msg.dispatch("/test", showmsg);
    } else {
      error = msg.getError();
      Serial.print("error: ");
      Serial.println(error);
    }

  }

}
